//
//  GSGeometrieHelper+Private.h
//  GlyphsCore
//
//  Created by Martin Winter on 06/05/2022.
//  Copyright © 2022 schriftgestaltung.de. All rights reserved.
//

#import <GlyphsCore/GSGeometrieHelper.h>

NS_ASSUME_NONNULL_BEGIN

typedef NS_ENUM(NSInteger, GSCalcCurveMode) {
	GSCalcCurveModeFull = 0,
	GSCalcCurveModeFirstHalf = 1,
	GSCalcCurveModeSecondHalf = 2
};

/// @param count Always pass the full count of `originPoints` and `originDirections`.
/// @param mode Specify whether to calculate the error of the entire curve, the first half, or the second half.
CGFloat GSCalcCurveError(NSPoint bezCurve[_Nonnull 4], const NSPoint *originPoints, const NSPoint *__nullable originDirections, unsigned short count, GSCalcCurveMode mode);

void GSOriginDirectionsFromCurve(const NSPoint *_Nonnull fitPoints, const NSPoint *_Nonnull originPoints, NSPoint *originDirections, unsigned short count);

NS_ASSUME_NONNULL_END
